'''
# @Author       : Chr_
# @Date         : 2020-12-16 18:53:26
# @LastEditors  : Chr_
# @LastEditTime : 2020-12-16 21:23:53
# @Description  : 优化镜像文件名,支持常见的系统名称
# @Description  : 问题反馈: chr@chrxw.com
'''

import os


def get_volume_name() -> str:
    while True:
        print('[?]请输入镜像文件所在盘符: ', end='')
        d = input().upper() or 'E'
        d += ':' + os.sep
        if os.path.exists(d):
            break
        else:
            print('[×]路径不存在')
    print(f'[=]目标设为{d},按Ctrl+C终止执行,按回车键继续……')


def format_name(name) -> str:
    name = str(name).lower().title()
    dic = {'Centos': 'CentOS', 'Dvd': 'DVD', 'Ms-': 'MS-',
           'Freebsd': 'FreeBSD', 'Bit': 'bit', 'Xp': 'XP',
           'Cd': 'CD', 'Opensuse': 'openSUSE', 'Dos': 'DOS',
           'Cn_': 'CN_', 'En_': 'EN_', 'Vl': 'VL', 'Pe': 'PE', }
    for x, y in dic.items():
        name = name.replace(x, y, 1)
    return name


def main():
    target = get_volume_name()
    for path, _, file_list in os.walk(target, topdown=False):
        for file_name in file_list:
            if 'ventoy' in path or 'Information' in path:
                break
            file_name2 = format_name(file_name)
            if 'ventoy' in file_name or file_name == file_name2:
                continue
            x = os.path.join(target, file_name)
            y = os.path.join(target, file_name+'_')
            z = os.path.join(target, file_name2)
            print(f'[-]{file_name} => {file_name2}')
            os.rename(x, y)
            os.rename(y, z)
    print('[!]运行结束')


if __name__ == "__main__":
    try:
        main()
    except KeyboardInterrupt:
        pass
