#include <AT89X51.H>
#define uchar unsigned char
#define uint unsigned int
//字形码
uchar cc[10] = {0x3f, 0x06, 0x5b, 0x4f, 0x66,
                0x6d, 0x7d, 0x07, 0x7f, 0x6f};
//数码管显示缓存
uchar disp[4] = {0, 0, 0, 0};
//延时函数 t为毫秒(不准)
void delay(uint t)
{
  uint i;
  while (t--)
  {
    for (i = 125; i; i--)
      ;
  }
}
//刷新数码管显示
void flash_display()
{
  uchar seg; //当前操作的位数
  for (seg = 0; seg < 4; seg++)
  {
    P3 = ~(1 << seg);   //只点亮某一个数码管
    P2 = cc[disp[seg]]; //显示disp中的数字
    delay(10);          //等待数码管响应
    P3 = 0xff;
    //delay(1); //熄灭数码管，防止残留显示
  }
}
//主程入口
void main()
{
  uchar flag = 0; //标记按键是否按下,1按下,0松开
  P1 = 0xff;      //P1所有脚输出高电平
  for (;;)
  //死循环，和while(1)等价
  {
    if ((P1 & 0x0f) != 0x0f)
    //判断有无按键按下
    {
      delay(10); //延时消除抖动
      if ((P1 & 0x0f) != 0x0f)
      {
        if (!flag)
        {//第一次按下
          flag = 1;

          if (!(P1 & 0x01))
          //P1.0相连的按键被按下
          {
            if (++disp[0] > 9)
            {
              disp[0] = 0;
            }
          }
          if (!(P1 & 0x02))
          //P1.1相连的按键被按下
          {
            if (++disp[1] > 9)
            {
              disp[1] = 0;
            }
          }
          if (!(P1 & 0x04))
          //P1.2相连的按键被按下
          {
            if (++disp[2] > 9)
            {
              disp[2] = 0;
            }
          }
          if (!(P1 & 0x08))
          //P1.3相连的按键被按下
          {
            if (++disp[3] > 9)
            {
              disp[3] = 0;
            }
          }
        }
      }
      else
      {//按键松开，将flag置0
        flag = 0;
      }
    }
    else
    {//按键松开，将flag置0
      flag = 0;
    }
    flash_display();//刷新数码管
  }
}