#include <AT89X51.H>
#define uchar unsigned char
#define uint unsigned int
uchar ca[11] = {0xc0, 0xf9, 0xa4, 0xb0, 0x99,
                0x92, 0x82, 0xf8, 0x80, 0x90,
                0x7f}; //CA(共阳极)数码管字形码
uchar cc[11] = {0x3f, 0x06, 0x5b, 0x4f, 0x66,
                0x6d, 0x7d, 0x07, 0x7f, 0x6f,
                0x80}; //CC(共阴极)数码管字形码
//延时函数 t为毫秒(不准)
void delay(uint t)
{
  uint i;
  while (t--)
  {
    for (i = 120; i; i--)
      ;
  }
}
//主程入口
void main()
{
  uchar *p = ca; //指针，用于切换字形码
  char n = 0;    //当前显示的数字
  P1 = 0xff;     //P1所有脚输出高电平
  for (;;)
  //死循环，和while(1)等价
  {
    if ((P1 & 0x07) != 0x07)
    //判断P2的1,2脚是不是高电平
    {
      delay(10); //延时消除抖动
      if (!(P1 & 0x01))
      //P2.0相连的按键被按下
      {
        if (--n < 0)
        {
          n = 10;
        }
      }
      if (!(P1 & 0x02))
      //P1.1相连的按键被按下
      {
        if (++n > 10)
        {
          n = 0;
        }
      }
      if (!(P1 & 0x04))
      //P1.2相连的按键被按下
      {
        if (*p == 0xc0)
        //指针p指向ca
        {
          p = cc;
        }
        else
        {
          p = ca;
        }
      }
    }
    P2 = *(p + n); //控制P1输出
    delay(200);     //粗略延时
  }
}