#include <AT89X51.H>
#define uchar unsigned char
#define uint unsigned int
//字形码(0-9)
uchar ca[10] = {0xc0, 0xf9, 0xa4, 0xb0, 0x99,
                0x92, 0x82, 0xf8, 0x80, 0x90};
//延时函数 t为毫秒(不准)
void delay(uint t)
{
  uint i;
  while (t--)
  {
    for (i = 1200; i; i--)
      ;
  }
}
//刷新两个数码管
void display(uchar m, uchar n)
{
  P2_0 = 0;
  P3 = ca[m];
  P2_0 = 1;//更新锁存器1

  P2_1 = 0;
  P3 = ca[n];
  P2_1 = 1;//更新锁存器2
}
//主程入口
void main()
{
  uchar m = 0; //数码管1显示的数字
  uchar n = 0; //数码管2显示的数字
  P1 = 0xff;   //P1所有脚输出高电平
  display();   //更新显示
  for (;;)
  //死循环，和while(1)等价
  {
    if ((P1 & 0x07) != 0x07)
    //判断P1的1,2,3脚是不是高电平
    {
      delay(10); //延时消除抖动
      if (!(P1 & 0x01))
      //按键1
      {
        if (++m > 9)
        {
          m = 0;
        }
        display(m, n);
      }
      if (!(P1 & 0x02))
      //按键2
      {
        if (++n > 9)
        {
          n = 0;
        }
        display(m, n);
      }
      if (!(P1 & 0x04))
      //按键3，清除锁存器
      {
        P2_2 = 0;
        delay(10);
        P2_2 = 1;
      }
    }
    delay(10); //粗略延时
  }
}